/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.nhm.eui;

import ibm.nways.jdm.eui.ColumnLayout;
import ibm.nways.nhm.eui.DateTimeEntry;
import java.awt.Dimension;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.util.Date;
import java.util.ResourceBundle;
import jclass.bwt.JCCheckbox;
import jclass.bwt.JCCheckboxGroup;
import jclass.bwt.JCItemEvent;
import jclass.bwt.JCItemListener;

public class TimeSelectionPanel
extends Panel
implements JCItemListener {
    private static Dimension sz = new Dimension(545, 275);
    private ResourceBundle nhmRes = ResourceBundle.getBundle("ibm.nways.nhm.eui.NhmResources");
    private boolean startTimeMode = false;
    private DateTimeEntry efStartDate;
    private DateTimeEntry efEndDate;
    private JCCheckboxGroup radioGroup;
    private TextField efTimeValue;
    private Label lUnits;
    private Panel p1;
    private Panel p2;
    private int currentTimeSelection;
    private String[] timeLabels;

    public TimeSelectionPanel(boolean bl) {
        this.startTimeMode = bl;
        this.initialize(null, 7, 0);
    }

    public TimeSelectionPanel(Date date, int n, int n2) {
        this.startTimeMode = true;
        this.initialize(date, n, n2);
    }

    private void initialize(Date date, int n, int n2) {
        this.setLayout(new ColumnLayout());
        this.timeLabels = new String[4];
        this.timeLabels[0] = this.nhmRes.getString("s_hours");
        this.timeLabels[1] = this.nhmRes.getString("s_days");
        this.timeLabels[2] = this.nhmRes.getString("s_weeks");
        this.timeLabels[3] = this.nhmRes.getString("s_months");
        Object[] objectArray = new String[]{this.nhmRes.getString("s_hourly"), this.nhmRes.getString("s_daily"), this.nhmRes.getString("s_weekly"), this.nhmRes.getString("s_monthly"), this.nhmRes.getString("s_specifyTimes")};
        this.radioGroup = JCCheckbox.makeGroup(objectArray, null, true);
        this.radioGroup.setTitle(this.nhmRes.getString("s_timePeriod"));
        this.radioGroup.addItemListener(this);
        this.add(this.radioGroup);
        this.p1 = new Panel();
        if (this.startTimeMode) {
            this.p1.add(new Label(this.nhmRes.getString("s_sDate")));
            this.efStartDate = date == null ? new DateTimeEntry() : new DateTimeEntry(date);
            this.p1.add(this.efStartDate);
        } else {
            this.p1.setVisible(false);
        }
        this.add(this.p1);
        this.p2 = new Panel();
        if (n == 0) {
            this.p2.add(new Label(this.nhmRes.getString("s_eDate")));
            this.efEndDate = new DateTimeEntry(this.efStartDate.getDate());
            this.p2.add(this.efEndDate);
        } else {
            if (this.startTimeMode) {
                this.p2.add(new Label(this.nhmRes.getString("s_for1")));
            } else {
                this.p2.add(new Label(this.nhmRes.getString("s_for")));
            }
            this.efTimeValue = new TextField(7);
            if (n2 != 0) {
                ((TextComponent)this.efTimeValue).setText(String.valueOf(n2));
            } else {
                n2 = 1;
                ((TextComponent)this.efTimeValue).setText(String.valueOf(n2));
            }
            this.p2.add(this.efTimeValue);
            this.lUnits = new Label("           ");
            this.p2.add(this.lUnits);
        }
        this.add(this.p2);
        this.currentTimeSelection = 2;
        if (n != 7) {
            if (n == 0) {
                this.currentTimeSelection = 4;
            } else {
                this.currentTimeSelection = n - 2;
                this.lUnits.setText(this.timeLabels[this.currentTimeSelection]);
            }
        } else {
            this.lUnits.setText(this.timeLabels[this.currentTimeSelection]);
        }
        this.radioGroup.getCheckbox(this.currentTimeSelection).setState(1);
    }

    public int getTimeLength() {
        int n = 1;
        try {
            n = Integer.parseInt(this.efTimeValue.getText());
        }
        catch (NumberFormatException numberFormatException) {}
        return n;
    }

    public int getTimeRange() {
        int n;
        switch (this.currentTimeSelection) {
            case 4: {
                n = 0;
                break;
            }
            case 3: {
                n = 5;
                break;
            }
            case 2: {
                n = 4;
                break;
            }
            case 1: {
                n = 3;
                break;
            }
            default: {
                n = 2;
            }
        }
        return n;
    }

    public Date getStartDate() {
        Date date = null;
        if (this.currentTimeSelection == 4 || this.startTimeMode) {
            date = this.efStartDate.getDate();
        }
        return date;
    }

    public Date getEndDate() {
        Date date = null;
        if (this.currentTimeSelection == 4) {
            date = this.efEndDate.getDate();
        }
        return date;
    }

    public void setEnabled(boolean bl) {
        this.radioGroup.setEnabled(bl);
        if (this.currentTimeSelection == 4) {
            this.efStartDate.setEnabled(bl);
            this.efEndDate.setEnabled(bl);
            return;
        }
        if (this.startTimeMode) {
            this.efStartDate.setEnabled(bl);
        }
        this.efTimeValue.setEnabled(bl);
    }

    private void deselectSpecifyButton() {
        this.p2.removeAll();
        if (this.startTimeMode) {
            this.p2.add(new Label(this.nhmRes.getString("s_for1")));
        } else {
            this.p2.add(new Label(this.nhmRes.getString("s_for")));
        }
        this.efTimeValue = new TextField(7);
        this.p2.add(this.efTimeValue);
        this.p2.add(this.lUnits);
        if (!this.startTimeMode) {
            this.p1.setVisible(false);
        }
    }

    public void itemStateChanged(JCItemEvent jCItemEvent) {
        if (jCItemEvent.getStateChange() == 1) {
            if (jCItemEvent.getSource() == this.radioGroup.getCheckbox(4)) {
                if (!this.startTimeMode && this.efStartDate == null) {
                    this.p1.add(new Label(this.nhmRes.getString("s_sDate")));
                    this.efStartDate = new DateTimeEntry();
                    this.p1.add(this.efStartDate);
                }
                if (!this.startTimeMode) {
                    this.p1.setVisible(true);
                    this.p1.validate();
                }
                this.p2.removeAll();
                this.p2.add(new Label(this.nhmRes.getString("s_eDate")));
                this.efEndDate = new DateTimeEntry(this.efStartDate.getDate());
                this.p2.add(this.efEndDate);
                this.currentTimeSelection = 4;
            } else {
                if (this.currentTimeSelection == 4) {
                    this.deselectSpecifyButton();
                }
                this.currentTimeSelection = this.radioGroup.getSelected()[0];
                this.lUnits.setText(this.timeLabels[this.currentTimeSelection]);
            }
            this.validate();
        }
    }

    public Dimension getMinimumSize() {
        return sz;
    }

    public Dimension getPreferredSize() {
        return sz;
    }
}

